clear all
clc
close all


%% Create Data

load AALabData
Y=Action;
indne=IndNE;
features=FeaturesAct;
Row=row;
clear row column

load AANewData
Y=[Y;modal'];
indne=[indne;IndNE];
features=[features;FeaturesAct];
Row=[Row;row'];
clear row column

load AAMTData
m=length(row);
YMT=zeros(1,m);
for i=1:m
    YMT(i)=modal{i}(1);
end
features=[features;FeaturesAct];
Row=[Row;row];

Y=[Y;YMT'];
indne=[indne;IndNE];

n=length(Y);

%% Uniform NE

% Randomize prediction over NE
Q=1000; %number of iterations
AccNE=zeros(1,Q);
for q=1:Q
    accne=zeros(1,n);
    for i=1:n
        ne=find(indne{i});
        m=length(ne);
        if m>0
            r=randi(m);
            accne(i)=logical(Y(i)==ne(r));
            clear ne
        else
            r=randi(3);
            accne(i)=logical(Y(i)==r);
        end
    end
    AccNE(q)=mean(accne);
end

'Accuracy Uniform-NE'
mean(AccNE)

'Standard Error'
sqrt(var(AccNE))


%% Level-1

% Find Level 1 Prediction
lev1=cell(1,n);
for i=1:n
    sumrow=sum(Row{i},2);
    lev1{i}=find(sumrow==max(sumrow));
end

'Level 1 Accuracy'
% Randomize prediction when not unique
Q=1000;
AccLev1=zeros(1,Q);
for q=1:Q
    [resampleY,ind]=datasample(Y,n);
    resamplelev1=lev1(ind);
    acclev1=zeros(1,n);
    for i=1:n
        m=length(lev1{i});
        pred=randi(m);
        acclev1(i)=logical(Y(i)==lev1{i}(pred));
    end
    AccLev1(q)=mean(acclev1);
end

'Accuracy Level-1'
mean(AccLev1)

'Level-1 SE'
sqrt(var(AccLev1))


%% Predict if Pareto-Dominant NE

ind=[3,15,27];
FeatParetoNE=features(:,ind);

Q=50;
ErrParetoNE=zeros(1,Q);
for q=1:50
    error=zeros(1,n);
    for i=1:n
        paretoNE=find(FeatParetoNE(i,:));
        m=length(paretoNE);
        if m>0
            r=randi(m);
            error(i)=logical(paretoNE(r)~=Y(i));
        else
            r=randi(3);
            error(i)=logical(r~=Y(i));
        end
    end
    ErrParetoNE(q)=mean(error);
end

'Accuracy predicting Pareto NE'
1-mean(ErrParetoNE)

'Standard Error'
sqrt(var(ErrParetoNE))


%% Lexicographic Rule: predict if Pareto-Dominant NE, then Lev1(alpha)

% Find Level 1(alpha) Prediction
alpha=0.41;
lev1R=zeros(1,n);
for i=1:n
    sumrow=sum(Row{i}.^alpha,2);
    lev1R(i)=find(sumrow==max(sumrow));
end

error=zeros(1,n);
for i=1:n
    paretoNE=find(FeatParetoNE(i,:));
    m=length(paretoNE);
    if m>0
        r=randi(m);
        error(i)=logical(paretoNE(r)~=Y(i));
    else
        error(i)=logical(lev1R(i)~=Y(i));
    end
end

'Accuracy using Lexicographic Rule'
1-mean(error)
